/**
* \file: mlink_gst_internals.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* MLINK GST Adapter
*
* \component: mlink
*
* \author: Venkata Sai Ganesh Deety RBEI/ECF34 VenkataSaiGanesh.Deety@in.bosch.com
*
* \copyright: (c) 2003 - 2013 ADIT Corporation
*
* \history
* 0.1 Venkata Sai Ganesh Deety Initial version
*
***********************************************************************/

#ifndef _MLINK_GST_INTERNALS_H_
#define _MLINK_GST_INTERNALS_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include <mlink_gst.h>

#include <gst/gst.h>
#include <gst/base/gstbasesink.h>
#include <stdlib.h>
#include <gio/gio.h>
#include <pthread.h>
#include <glib.h>
#include <netinet/in.h>


struct mlink_rtp_out_context
{
    GMutex mutex;
    GCond init_cond;
    int init_finished;

    GThread *gst_thread;

    GMainLoop * gst_mainloop;
    GMainContext * g_main_context;
    GstElement * pipeline;
    unsigned int payloadtype;
    unsigned int channels;
    unsigned int samplerate;
    unsigned int ipl_ms;
    unsigned int ipaddr;
    unsigned int port;
#ifdef GST_VERSION_1
    GSocket * sock;
#else
    int sock;
#endif
    gchar * playback_device;

    GstElement * sinkElement;
    GstElement * volumeElement;
    GstElement * outputSelector;
    GstElement * valveElement;
    GstPad * outputSelectorPad1;
    GstPad * outputSelectorPad2;

    gint32 volumeBufferProbeHandlerId;
    GstClockTime nextPreSinkBufferTime;

    gboolean isFirstRTPPacket;
    guint32 prevPayloadLen;
    guint32 prevRTPTimestamp;
    guint32 currRTPTimestamp;

    gboolean disconnected;

    gboolean marker_bit_observed;
    gboolean new_data_after_marker_bit_observed;

    mlink_gst_rtp_out_error_callback * error_cb;
    mlink_gst_rtp_out_data_callback * data_cb;
    mlink_gst_streaming_thread_callback * streaming_thread_cb;
    void * p_user_ctx;
    DltContext * p_dlt_ctx;
};

/*We need 3*4=12 bytes (three 32bit words) to add an Extension Header for Voice Command */
#define RTPIN_VC_HEADER_EXTN_SIZE 12

struct mlink_rtp_in_context
{
	GMutex  mutex;
    GCond init_cond;
    int init_finished;

	GThread *gst_thread;

    GMainLoop * gst_mainloop;
    GMainContext * g_main_context;
    GstElement * pipeline;
    u_int16_t sequence_number;
    u_int32_t timestamp;
    u_int32_t ssrc_identifier;
    u_int8_t csrc_count;
    unsigned int payloadtype;
    unsigned int channels;
    unsigned int samplerate;
    unsigned int ipaddr;
    unsigned int port;
    gchar * capture_device;

#ifdef GST_VERSION_1
    GSocket * sock;
#else
    int sock;
#endif

    mlink_gst_rtp_in_error_callback * error_cb;
    mlink_gst_streaming_thread_callback * streaming_thread_cb;

    void * p_user_ctx;
    DltContext * p_dlt_ctx;
};

struct rtp_header
{
    struct
    {
#if __BYTE_ORDER == __BIG_ENDIAN
        u_int8_t version :2;
        u_int8_t padding :1;
        u_int8_t extension :1;
        u_int8_t csrc_count :4;

        u_int8_t marker :1;
        u_int8_t payload_type :7;

        u_int16_t sequence_number;
#endif
#if __BYTE_ORDER == __LITTLE_ENDIAN
        u_int8_t csrc_count :4;
        u_int8_t extension :1;
        u_int8_t padding :1;
        u_int8_t version :2;

        u_int8_t payload_type :7;
        u_int8_t marker :1;

        u_int16_t sequence_number :16;
#endif
    }__attribute__((packed));

    u_int32_t timestamp;
    u_int32_t ssrc_identifier;
}__attribute__((packed));

void *mlink_gst_run_rtp_out_pipeline(void * parameter);
void *mlink_gst_run_rtp_in_pipeline(void * parameter);

void schedule_fade(GstElement* volume, GstClockTime fadeStart,
        double oldVol, double newVol, guint32 fadeMs,
        mlink_gst_ramp_type rampType, DltContext * p_dlt_ctx);

GstBusSyncReply mlink_gst_rtp_out_bus_call(GstBus *bus, GstMessage *msg, gpointer data);
GstBusSyncReply mlink_gst_rtp_in_bus_call(GstBus *bus, GstMessage *msg, gpointer data);

gboolean mlink_gst_stop_rtp_out_mainloop(gpointer data);

gboolean mlink_gst_stop_rtp_in_mainloop(gpointer data);

void mlink_gst_run_rtp_out_on_pad_added(GstElement *element, GstPad *pad,
        gpointer data);

void mlink_gst_log_vargs(DltContext * ctx, DltLogLevelType level, char * log_string, ...);
void mlink_gst_log(DltContext * ctx,DltLogLevelType level,char *msg);

#ifdef __cplusplus
}
#endif

#endif /* _MLINK_GST_INTERNALS_H_ */
